@extends('layouts.admin')

@section('title', 'Users Management')

@section('content')
<div class="dashboard-container">
    <div class="dashboard-header">
        <div class="d-flex justify-content-between align-items-center">
            <h1>Users Management</h1>
            {{-- If you want to add any action buttons like "Add User", place here --}}
            {{-- <a href="{{ route('admin.users.create') }}" class="btn btn-primary">
                <i class="fas fa-plus-circle"></i> Add User
            </a> --}}
        </div>
        <p>Manage your community members</p>
    </div>

    <div class="dashboard-card">
        <div class="dashboard-card-header">
            <h3>Users</h3>
        </div>
        <div class="dashboard-card-body">
            <div class="users-filters mb-3">
                <form action="{{ route('admin.users.index') }}" method="GET" class="w-100">
                    <div class="d-flex gap-3 flex-wrap align-items-end">
                        <div class="filter-group flex-grow-1">
                            <label for="search">Search</label>
                            <input 
                                type="text" 
                                id="search" 
                                name="search" 
                                value="{{ request('search') }}" 
                                placeholder="Search by name or Steam ID" 
                                class="form-control"
                            >
                        </div>
                        <div class="filter-group">
                            <label for="role">Role</label>
                            <select id="role" name="role" class="form-select">
                                <option value="">All Roles</option>
                                @foreach($roles as $role)
                                    <option value="{{ $role }}" {{ request('role') == $role ? 'selected' : '' }}>
                                        {{ ucfirst($role) }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="filter-actions d-flex gap-2">
                            <button type="submit" class="btn btn-primary">Filter</button>
                            <a href="{{ route('admin.users.index') }}" class="btn btn-secondary">Reset</a>
                        </div>
                    </div>
                </form>
            </div>

            <div class="table-responsive">
                <table class="table users-table align-middle">
                    <thead>
                        <tr>
                            <th>Avatar</th>
                            <th>Name</th>
                            <th>Steam ID</th>
                            <th>Roles</th>
                            <th>Last Active</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($users as $user)
                            <tr>
                                <td>
                                    <img src="{{ $user->avatar }}" alt="{{ $user->name }}" class="avatar-sm rounded-circle">
                                </td>
                                <td>{{ $user->name }}</td>
                                <td>
                                    @if($user->steamid)
                                    <a href="{{ $user->getSteamProfileUrl() }}" target="_blank" class="steam-link">
                                        {{ $user->steamid }}
                                        <i class="fas fa-external-link-alt ms-1"></i>
                                    </a>
                                    @else
                                        —
                                    @endif
                                </td>
                                <td>
                                    @forelse($user->roles as $role)
                                        <span class="user-role 
                                            {{ strtolower($role->name) == 'admin' ? 'role-admin' : (strtolower($role->name) == 'moderator' ? 'role-moderator' : 'role-user') }}">
                                            {{ $role->name }}
                                        </span>
                                    @empty
                                        <span class="user-role role-user">User</span>
                                    @endforelse
                                </td>
                                <td>{{ $user->last_active_at ? $user->last_active_at->diffForHumans() : 'Never' }}</td>
                                <td>
                                    <div class="user-actions d-flex gap-2">
                                        <a href="{{ route('admin.users.show', $user) }}" class="btn-icon btn-info" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('admin.users.edit', $user) }}" class="btn-icon btn-success" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        @if(auth()->id() !== $user->id)
                                            <form action="{{ route('admin.users.destroy', $user) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this user?');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn-icon btn-danger" title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center">No users found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="pagination mt-3">
                {{ $users->appends(request()->query())->links() }}
            </div>
        </div>
    </div>
</div>
@endsection
